#include <linux/types.h>
//#include "../../CrestCore/inc/interface/dm_os.h"
//#include "../../CrestCore/inc/interface/dm_nutypedefs.h"
//#include "dm_nutypedefs.h"

/* ioctls */
// These look windows specific.
//IOCTL_POWER_CAPABILITIES
//IOCTL_POWER_QUERY
//IOCTL_POWER_SET
//IOCTL_POWER_GET

//These look like debug functions that were never used.
//HPR_IOCTL_HPRF_SETGPIO
//HPR_IOCTL_HPRF_CLRGPIO
//HPR_IOCTL_HPRF_GETGPIO
//HPR_IOCTL_POWER_ON
//HPR_IOCTL_POWER_OFF
//HPR_IOCTL_QUERY_POWER_STATE

//typedef struct {
//    UINT8 flags;
//    UINT8 controlCode;
//} hpr_ioctl_debug;

typedef struct {
    uint8_t flags;
    uint8_t controlCode;
} hpr_ioctl_debug;

typedef struct
{
    uint32_t dwCode;
} RF_DIAG_CTRL;

typedef struct
{
    uint32_t dwCode;
} RF_TEST_CTRL;

#define HPR_IOCTL_TYPE ('e' + 'r')

#define UID_MAX_SIZE            8
#define GATEWAY_NAME_MAX_SIZE   50

#define HPRF_CTRL_MSG_ACQUIRE_SUCCESS       1
#define HPRF_CTRL_MSG_ACQUIRE_TIMEOUT       2
#define HPRF_CTRL_MSG_ACQUIRE_FAIL          3
#define HPRF_CTRL_MSG_GW_CONNECTED          4
#define HPRF_CTRL_MSG_GW_DISCONNECTED       5
#define HPRF_CTRL_MSG_CTRL_SYS_CONNECTED    6
#define HPRF_CTRL_MSG_CTRL_SYS_DISCONNECTED 7
#define HPRF_CTRL_MSG_LQI_DATA              8

//////////////////////////////////////////////
// Debug flags for the IOCTL handling (this value should be same as that in application)
#define RF_RFTX_DEBUG_FLAG      0x01
#define RF_RFRX_DEBUG_FLAG      0x02
#define RF_GENERIC_DEBUG_FLAG   0x04
#define RF_ALL_DEBUG_FLAG       (RF_RFTX_DEBUG_FLAG | RF_RFRX_DEBUG_FLAG | RF_GENERIC_DEBUG_FLAG)

// Actual ioctls with implementation.
#define HPR_IOCTL_ACQUIRE_START         _IOW(HPR_IOCTL_TYPE, 0, unsigned)
#define HPR_IOCTL_ACQUIRE_STOP          _IO(HPR_IOCTL_TYPE, 1)
#define HPR_IOCTL_SET_RF_ID             _IOW(HPR_IOCTL_TYPE, 2, unsigned char)
#define HPR_IOCTL_GET_RF_ID             _IOR(HPR_IOCTL_TYPE, 3, unsigned char)
#define HPR_IOCTL_SET_RF_CHANNEL        _IOW(HPR_IOCTL_TYPE, 4, unsigned char)
#define HPR_IOCTL_GET_RF_CHANNEL        _IOR(HPR_IOCTL_TYPE, 5, unsigned char)
#define HPR_IOCTL_SET_RF_POWER_HI_LOW   _IOW(HPR_IOCTL_TYPE, 6, unsigned char)
#define HPR_IOCTL_GET_RF_POWER_HI_LOW   _IOR(HPR_IOCTL_TYPE, 7, unsigned char)
#define HPR_IOCTL_RF_APP_INIT_DONE      _IO(HPR_IOCTL_TYPE, 8)
#define HPR_IOCTL_GET_GW_UID            _IOR(HPR_IOCTL_TYPE, 9, unsigned char[UID_MAX_SIZE])
//HPR_IOCTL_GET_GW_UID_STRING
#define HPR_IOCTL_SET_GW_UID            _IOW(HPR_IOCTL_TYPE, 11, unsigned char[UID_MAX_SIZE])
#define HPR_IOCTL_GET_UID               _IOR(HPR_IOCTL_TYPE, 12, unsigned char[UID_MAX_SIZE])
//HPR_IOCTL_GET_UID_STRING
#define HPR_IOCTL_SET_UID               _IOW(HPR_IOCTL_TYPE, 14, unsigned char[UID_MAX_SIZE])
#define HPR_IOCTL_GW_CONN_QUERY         _IOR(HPR_IOCTL_TYPE, 15, unsigned int) //really a boolean
#define HPR_IOCTL_CS_CONN_QUERY         _IOR(HPR_IOCTL_TYPE, 16, unsigned int) //really a boolean
#define HPR_IOCTL_GW_ACQUIRED_QUERY     _IOR(HPR_IOCTL_TYPE, 17, unsigned int) //really a boolean
#define HPR_IOCTL_GET_GW_NAME           _IOR(HPR_IOCTL_TYPE, 18, unsigned char[GATEWAY_NAME_MAX_SIZE])
#define HPR_IOCTL_GET_SIGNAL_STRENGTH   _IOR(HPR_IOCTL_TYPE, 19, unsigned int)
#define HPR_IOCTL_LQI_START             _IO(HPR_IOCTL_TYPE, 20)
#define HPR_IOCTL_LQI_STOP              _IO(HPR_IOCTL_TYPE, 21)
#define HPR_IOCTL_GET_RF_PWR_BOOST      _IOR(HPR_IOCTL_TYPE, 22, unsigned char)
#define HPR_IOCTL_SET_RF_PWR_BOOST      _IOW(HPR_IOCTL_TYPE, 23, unsigned char)
#define HPR_IOCTL_GET_RF_DEBUG          _IOWR(HPR_IOCTL_TYPE, 24, hpr_ioctl_debug)
#define HPR_IOCTL_SET_RF_DEBUG          _IOWR(HPR_IOCTL_TYPE, 25, hpr_ioctl_debug)
#define HPR_IOCTL_GET_PAN_ID            _IOWR(HPR_IOCTL_TYPE, 26, unsigned short)
#define HPR_IOCTL_SET_PAN_ID            _IOWR(HPR_IOCTL_TYPE, 27, unsigned short)
#define HPR_GET_IOCTL_GATEWAY_PAN_ID    _IOWR(HPR_IOCTL_TYPE, 28, unsigned short)
#define HPR_SET_IOCTL_GATEWAY_PAN_ID    _IOWR(HPR_IOCTL_TYPE, 29, unsigned short)
#define HPR_GET_IOCTL_CCA_THRESHOLD     _IOWR(HPR_IOCTL_TYPE, 30, unsigned char)
#define HPR_SET_IOCTL_CCA_THRESHOLD     _IOWR(HPR_IOCTL_TYPE, 31, unsigned char)
#define HPR_GET_IOCTL_RSSI_COMP_OFFSET  _IOWR(HPR_IOCTL_TYPE, 32, unsigned char)
#define HPR_SET_IOCTL_RSSI_COMP_OFFSET  _IOWR(HPR_IOCTL_TYPE, 33, unsigned char)
#define HPR_GET_IOCTL_RF_RETRY          _IOWR(HPR_IOCTL_TYPE, 34, unsigned char)
#define HPR_SET_IOCTL_RF_RETRY          _IOWR(HPR_IOCTL_TYPE, 35, unsigned char)
#define HPR_IOCTL_GET_RETRY_COUNT_ON_CONN _IOWR(HPR_IOCTL_TYPE, 36, unsigned char)
#define HPR_IOCTL_SET_RETRY_COUNT_ON_CONN _IOWR(HPR_IOCTL_TYPE, 37, unsigned char)
#define HPR_GET_IOCTL_PRE_LINK_COUNT    _IOWR(HPR_IOCTL_TYPE, 38, unsigned char)
#define HPR_SET_IOCTL_PRE_LINK_COUNT    _IOWR(HPR_IOCTL_TYPE, 39, unsigned char)
#define HPR_IOCTL_UPDATE_RADIO_DATA     _IOW(HPR_IOCTL_TYPE, 32, unsigned int)
#define HPR_IOCTL_RF_TESTS              _IOWR(HPR_IOCTL_TYPE, 33, RF_TEST_CTRL)
#define HPR_IOCTL_DIAGNOSTICS           _IOWR(HPR_IOCTL_TYPE, 34, RF_DIAG_CTRL)

#define HPR_MAX_PIPE_PACKET_SIZE        768

#ifdef __KERNEL__

#define MC_USE_CDEV 1

// Forgive me for my sins.
#include "hprfgw_config.h"
#include "hprfgw_rfSharedDefs.h"
#include <linux/gpio.h>

#ifdef MC_USE_CDEV
 #include <linux/cdev.h>
#else
 #include <linux/miscdevice.h>
#endif
#include <linux/kfifo.h>
#include <linux/workqueue.h>
#include <linux/crestron.h>

struct task_struct;

enum MC13192_PIN {
    MC13192_RADIO_ON,
    MC13192_N_RESET,
    MC13192_N_IRQ,
    MC13192_N_RXEN,
    MC13192_N_TXEN,
    MC13192_RXTXEN,
    MC13192_N_ATTN,
    MC13192_PAEN,
    MC13192_ID01,
    MC13192_ID02,
    MC13192_ID03,
    MC13192_NUM_PINS,
};
struct mc13192_platform_data {
    int pins[MC13192_NUM_PINS];
};
#define UID_SIGN                0xD00F

/**
 * This is really platform specific data.
 * TODO: Make this go into a 600/900 platform file, or passed into the driver as arguments.
 */
#define HPRF_GPIONUM_RADIO_ON IMX_GPIO_NR(2,7)
#define HPRF_GPIONUM_N_RESET  IMX_GPIO_NR(2,6)
#define HPRF_GPIONUM_N_IRQ    IMX_GPIO_NR(2,15)
#define HPRF_GPIONUM_N_RXEN   IMX_GPIO_NR(2,3)
#define HPRF_GPIONUM_N_TX_EN  IMX_GPIO_NR(2,5)
#define HPRF_GPIONUM_RXTXEN   IMX_GPIO_NR(2,1)
#define HPRF_GPIONUM_N_ATTN   IMX_GPIO_NR(2,2)
#define HPRF_GPIONUM_PAEN     IMX_GPIO_NR(2,0)

#define HPRF_GPIONUM_FCC_ID01 IMX_GPIO_NR(2,14)
#define HPRF_GPIONUM_FCC_ID02 IMX_GPIO_NR(2,13)
#define HPRF_GPIONUM_FCC_ID03 IMX_GPIO_NR(2,12)

void IRQPinEnable(void);
void MC13192_IRQ_Disable(void);
void MC13192_IRQ_Enable(void);
void IRQACK(void);

// Send Control message to Application
UINT32 SendCtrlMsgToApp(void *lpBuffer, UINT32 cbDataSize);
// Send Cresent packet to Application
UINT32 SendCresnetPacketToApp(void *lpBuffer, UINT32 cbDataSize);
// Send Local Cresent packet to Application
UINT32 SendLocalCresnetPacketToApp(void *lpBuffer, UINT32 cbDataSize);
// Send Diagnostics and test data messages to Application
UINT32 SendDiagDataToApp(void *lpBuffer, UINT32 cbDataSize);

//typedef struct
//{
//    UINT32 dwCode;
//}RF_DIAG_CTRL;
//
//typedef struct
//{
//    UINT32 dwCode;
//}RF_TEST_CTRL;
//
//typedef UINT32 DWORD;
typedef char CHAR;

/////////////////////////////////////////////////////////////////////////////////
// Control code and structures required for the RF diagnostics.
#define HPR_DIAG_CTRL_NONE              0
#define HPR_DIAG_CTRL_SHOW_DIAG_INFO    1
#define HPR_DIAG_CTRL_PHY_INFO          2
#define HPR_DIAG_CTRL_DESCR             3
#define HPR_DIAG_CTRL_RF_STACK_TRACE    4
#define HPR_DIAG_CTRL_RF_STACK_DIAG     5
#define HPR_DIAG_CTRL_RF_CLR_DIAG       6
#define HPR_DIAG_CTRL_RF_PHY_READ       7
#define HPR_DIAG_CTRL_RF_ERR_LOG        8
#define HPR_DIAG_CTRL_RF_NETLINK        9
#define HPR_DIAG_CTRL_RF_VERSION        10
#define HPR_DIAG_CTRL_RF_POWER_DBM      11

// PHY information
typedef struct
{
    UINT32 PhyInitFailed;
    UINT32 PhyChipId;
} RF_PHY_INFO;

// Structure for diag
typedef struct
{
    UINT32 Rfdiags_numTimer1Ints;
    UINT32 Rfdiags_numLOUnLockInts;
    UINT32 Rfdiags_numInvalidPhyPacketsRecvd;
    UINT32 Rfdiags_numCCA_TxDone;
    UINT32 Rfdiags_LowLevelRecvCnt;
    UINT32 Rfdiags_LowLevelRecvByteCnt;
    UINT32 Rfdiags_LowLevelTotalLostPackets;
    UINT32 Rfdiags_LowLevelInvalidRxPacketCnt;
    UINT32 Rfdiags_LowLevelRetryPacketCnt;
    UINT32 Rfdiags_LowLevelTxPacketCnt;
    UINT32 Rfdiags_LowLevelTxPacketBytes;
    UINT32 Rfdiags_LowLevelResets;
    UINT32 Rfdiags_numBadTimerISR;
    UINT32 Rfdiags_ChannelBusyResets;
    UINT32 Rfdiags_NumDataConfMessages;
    UINT32 Rfdiags_NumResetAndNacks;
    UINT32 Rfdiags_Congestion;
    UINT32 Rfdiags_Utilization;
    UINT32 Rfdiags_NumCCAFailures;
    UINT32 Rfdiags_NumCCATimeoutsFailures;
    UINT32 Rfdiags_NumRxInactivityResets;
}RF_DIAG;

// Strcture for HPR_DIAG_SHOW_LINK_INFO
typedef struct
{
    UINT32 linkstatecnt;
    UINT32 linkqualityAtLocalDevice;
    UINT32 txpacketcount;
    UINT32 txpacketretrycount;
    UINT32 rxpacketcount;
    UINT32 rxpacketrepeatcount;
    UINT32 rxpacketsequenceErrcount;
    UINT32 rxpacketsegmentationerrcnt;
    RF_DIAG rfdiag;
    RF_PHY_INFO PhyInfo;
}RF_DIAG_SHOW_DIAG_INFO;

// Strcture (input) for HPR_DIAG_CTRL_DESCR
typedef struct
{
    RF_DIAG_CTRL DiagCtrl;
    UINT32 index;
}RF_DIAG_DESCR;

// Structure to return the RF stack trace
#define SMAC_SM_DEBUG_NUMENTRIES    (10*1024)
typedef struct
{
    UINT16 SMAC_SM_Debug_State[SMAC_SM_DEBUG_NUMENTRIES];
    UINT32 SMAC_SM_Debug_Timestamp[SMAC_SM_DEBUG_NUMENTRIES];
    UINT32 SMAC_SM_Debug_State_Ctr;
}TYPE_RF_STACK_TRACE;

// Structure for RFSTACKDIAG (HPR_DIAG_CTRL_RF_STACK_DIAG)
typedef struct
{
    RF_DIAG rfdiag;
    UINT32 numResCodeTimeouts;
    UINT32 errpktcnt;
}TYPE_RF_STACK_DIAG;

// Structure for RFPHYREAD (HPR_DIAG_CTRL_RF_PHY_READ)
#define MC1319xDRV_MAX_REGS 0x32
typedef struct
{
    RF_DIAG_CTRL DiagCtrl;
    UINT32 ReadAddr;
    UINT32 ReadCount;
    UINT32 Data[MC1319xDRV_MAX_REGS];
}TYPE_RF_PHY_READ;

// Structure for Error logs
typedef struct
{
    RF_DIAG_CTRL DiagCtrl;
    UINT32 Control;          // 0 = Read, 1 = clear log
}TYPE_RF_DIAG_ERR_LOG;

// RF Netlink information
typedef struct
{
    UINT32 GwConn;           // 1 = connected, 0 = disconnected
    UINT32 CtrlSysConn;      // 1 = connected, 0 = disconnected
    UINT32 GwCtrlConnType;   // 0 = no connection, 1 = cresnet, 2 = ethernet
    UINT32 GwCnetId;         // Gateway cresnet Id
    CHAR  LinkStateStr[64]; // LinkState string
    CHAR  TimeStr[64];      // Link Duration string
    UINT32 LinkCount;
//TODO: FIXME: Float variables
//    FLOAT RxLQIinDev;       // Rec LQI in device (percent).
//    FLOAT RxLQIinGW;        // Rec LQI in GW (percent)
    UINT32 RxLQIinDev;       // Rec LQI in device (percent).
    UINT32 RxLQIinGW;        // Rec LQI in GW (percent)
}TYPE_RF_NETLINK_INFO;

// RF Version
typedef struct
{
    CHAR  RFVersion[64];
    CHAR  SmacVersion[64];
}TYPE_RF_VERSION_INFO;

// HPR_DIAG_CTRL_RF_POWER_DBM (power level in dBm based on channel and power hi lo)
typedef struct
{
    RF_DIAG_CTRL DiagCtrl;
    UINT32 Power;
    UINT32 Translate;
//TODO: FIXME: Float variables
//    FLOAT Power_dBm;
    UINT32 Power_dBm;
}TYPE_RF_POWER_DBM;

/////////////////////////////////////////////////////////////////////////////////
// Control code and structures for the diagnostics and test responses
// to be sent using the diagnostics queue to the application
#define HPRF_DIAG_DATA_NONE                     0
#define HPRF_DIAG_DATA_ECHO_TEST_REPLY          1
#define HPRF_DIAG_DATA_DESCR_COMMAND_REPLY      2
#define HPRF_DIAG_DATA_CONSOLE_PRINT            3

typedef struct  {
    uint32_t  repeatno;
    uint32_t  invalidresponses;
    uint32_t  noresponses;
    uint8_t   localrxlqi;
    uint8_t   remoterxlqi;
    uint32_t  avgrxlqi;
    uint32_t  avgremotedevicerxlqi;
    uint32_t  tick;
    uint32_t  txpacketcount;
    uint32_t  txpacketpayloadbytecount;
    uint32_t  rxpacketcount;
    uint32_t  rxpacketpayloadbytecount;

    uint32_t   done;                           //  TRUE=if tests are complete
}   TYPE_RF_DIAG_ECHO_REPLY_PACKET;
// Structure to return the diag data for DESCR command
typedef struct
{
    uint8_t Buffer[128];
    uint32_t dwStrLen;
}TYPE_RF_DIAG_DATA_DESCR_REPLY;


// Structure to send console printfs to application
// Make sure the total length of the HPR_TY_DiagData is note more
// than the Queue message size (260)
typedef struct
{
    uint8_t buffer[240];
    uint32_t dwStrLen;
}TYPE_RF_DIAG_CONSOLE_DATA;

// Test and diagnostics response structure generic.
typedef struct
{
    uint32_t dwDataCode;
    union
    {
        TYPE_RF_DIAG_ECHO_REPLY_PACKET EchoReply;
        TYPE_RF_DIAG_DATA_DESCR_REPLY DescReply;
        TYPE_RF_DIAG_CONSOLE_DATA Console;
                                                // << Add new packet types here
    }Data;
}HPR_TY_DiagData;

#define MAX_BOOT_ID_MESSAGE 128
struct ioctl_idString {
    UINT32 tsid;
    UINT8 bootIdMsg[MAX_BOOT_ID_MESSAGE];
};

typedef struct
{
    UINT8   UID[UID_MAX_SIZE];
    UINT16  panID;                    //default=TBD
    UINT16  shortAddr;                //default=0xFFFE;
    UINT8   addrMode;                 //default=3;
    UINT8   CCAEnergyDetectThr;       //default=TBD, for new set to 0x40
    UINT8   RSSIPowerCompOffset;      //    default=0x74
    UINT8   channel;                  //default=26;
    UINT16  power;                    //default=0xFFFF;  (THIS IS NOT USED)
    UINT8   retry;                    //default=3;
    UINT8   retrydelay[RF_MAX_NO_OF_RETRIES_DELAYS];
    UINT16  resultcodetimeout;        //default=2;  (1-second)
    UINT8   heartBeat;                //default=4;  (40-second) (1 count is 10-second)
    UINT8   link_retrydelay[RF_MAX_NO_OF_RETRIES_DELAYS]; // NOTE HS must fix this. Not defined
    UINT8   gatewayUID[UID_MAX_SIZE];// Obtained from acquire process
    UINT16  gatewayPanID;            // Obtained from acquire process
    UINT8   RFID;
    UINT8   RFTraceFlags;            // RF debug trace flags
    UINT8   powerhilo;
    UINT8   LinkLQIThreshold;        // Link LQI threshold (this was a spare before)
    UINT8   txPktretryonconnection;  // New param 11/3/2007 11:07PM
    UINT8   PreLinkQueryPacketCnt;   // New param 11/3/2007 11:08PM
    UINT8   powerBoost;              // add this boost to the high power
} RF_PARAM;

typedef struct
{
    INT8   gatewayUIDString[RF_DEVICE_MAX_CRESNET_ID_STRING_LEN];
    INT8   gatewayName[GATEWAY_NAME_MAX_SIZE];
    INT8   UIDString[RF_DEVICE_MAX_CRESNET_ID_STRING_LEN];
    UINT32 TSID;
    UINT32 UID_Valid;
}RF_PARAM_LOCAL;

struct mc13192_pipe_dev
{
    struct mutex read_mutex;
    struct mutex write_mutex; // Only used by data pipe
    spinlock_t slock;
    wait_queue_head_t wq;
    struct kfifo_rec_ptr_2 fifo; // queue to userspace
    /* Used to copy data into, since we cannot copy_to_user in an atomic context. */
    char tmp_read_buf[HPR_MAX_PIPE_PACKET_SIZE];

    struct device *dev;
    struct cdev cdev;
};

#define MAX_BOOT_ID_MESSAGE 128
struct mc13192
{
    struct spi_device *spi;
    struct work_struct work;
    struct mutex ioctl_mutex;

#ifdef MC_USE_CDEV
    struct mc13192_pipe_dev data_pipe;
    struct mc13192_pipe_dev ctl_pipe;
    struct mc13192_pipe_dev diag_pipe;

#else
    struct miscdevice dev;
#endif

    struct timer_list my_timer;
    bool timer_enabled;

    RF_PARAM rfparam;
    RF_PARAM_LOCAL rfparamlocal;

    // Variables that were global previously, pulled into mc13192.
    BOOL isAppInitDone;
    int hack_isSleeping;

    DM_RESOURCE_HANDLE lqiEvent;
    struct task_struct *lqiThread;
    BOOL lqiActive;
    UINT8 localDevLqi;
    UINT8 remoteLqi;

    UINT8 bootIdMsg[MAX_BOOT_ID_MESSAGE];
};

/* TODO: HACK: FIXME: UGLY: Generalized dm_spi interface not implemented yet.
 * See dm_spi.c and smac_mcu_spi_config_dmSpecific. */
extern struct spi_device *hprf_spi;

#endif //__KERNEL__

